
---
# RS 485 3 Click

> [RS485 3 Click](https://www.mikroe.com/?pid_product=MIKROE-2821) demo application is developed using
the [NECTO Studio](https://www.mikroe.com/necto), ensuring compatibility with [mikroSDK](https://www.mikroe.com/mikrosdk)'s
open-source libraries and tools. Designed for plug-and-play implementation and testing, the demo is fully compatible with
all development, starter, and mikromedia boards featuring a [mikroBUS&trade;](https://www.mikroe.com/mikrobus) socket.

<p align="center">
  <img src="https://www.mikroe.com/?pid_product=MIKROE-2821&image=1" height=300px>
</p>

---

#### Click Library

- **Author**        : MikroE Team
- **Date**          : Apr 2020.
- **Type**          : UART GPS/GNSS type

# Software Support

## Example Description

> This application is used to communicate between two RS485 Clicks. 

### Example Libraries

- MikroSDK.Board
- MikroSDK.Log
- Click.Rs4853

### Example Key Functions

- `rs4853_cfg_setup` Config Object Initialization function. 
```c
void rs4853_cfg_setup ( rs4853_cfg_t *cfg );
``` 
 
- `rs4853_init` Initialization function. 
```c
err_t rs4853_init ( rs4853_t *ctx, rs4853_cfg_t *cfg );
```

- `rs4853_generic_write` Generic write function. 
```c
void rs4853_generic_write ( rs4853_t *ctx, char *data_buf, uint16_t len );
```
 
- `rs4853_generic_read` Generic read function. 
```c
uint16_t rs4853_generic_read ( rs4853_t *ctx, char *data_buf, uint16_t max_len );
```

- `rs4853_send_command` Function ofr send command. 
```c
void rs4853_send_command ( rs4853_t *ctx, char *command );
```

### Application Init

> Initializes driver. 

```c
void application_init ( void )
{
    log_cfg_t log_cfg;
    rs4853_cfg_t cfg;

    /** 
     * Logger initialization.
     * Default baud rate: 115200
     * Default log level: LOG_LEVEL_DEBUG
     * @note If USB_UART_RX and USB_UART_TX 
     * are defined as HAL_PIN_NC, you will 
     * need to define them manually for log to work. 
     * See @b LOG_MAP_USB_UART macro definition for detailed explanation.
     */
    LOG_MAP_USB_UART( log_cfg );
    log_init( &logger, &log_cfg );
    log_info( &logger, "---- Application Init ----" );

    //  Click initialization.

    rs4853_cfg_setup( &cfg );
    RS4853_MAP_MIKROBUS( cfg, MIKROBUS_1 );
    rs4853_init( &rs4853, &cfg );
}
```

### Application Task

> Reads the received data.

```c
void application_task ( void )
{
#ifdef DEMO_APP_RECEIVER
    rs4853_process( );
#endif    

#ifdef DEMO_APP_TRANSMITER
    rs4853_send_command( &rs4853, TEXT_TO_SEND );
    rs4853_process( );
    Delay_ms ( 1000 );
    Delay_ms ( 1000 );
#endif     
}
```

## Application Output

This Click board can be interfaced and monitored in two ways:
- **Application Output** - Use the "Application Output" window in Debug mode for real-time data monitoring.
Set it up properly by following [this tutorial](https://www.youtube.com/watch?v=ta5yyk1Woy4).
- **UART Terminal** - Monitor data via the UART Terminal using
a [USB to UART converter](https://www.mikroe.com/click/interface/usb?interface*=uart,uart). For detailed instructions,
check out [this tutorial](https://help.mikroe.com/necto/v2/Getting%20Started/Tools/UARTTerminalTool).

## Additional Notes and Information

The complete application code and a ready-to-use project are available through the NECTO Studio Package Manager for 
direct installation in the [NECTO Studio](https://www.mikroe.com/necto). The application code can also be found on
the MIKROE [GitHub](https://github.com/MikroElektronika/mikrosdk_click_v2) account.

---
